<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>

<!-- 	Root Parameters: 
			This stylesheet must be called with 4 parameters:

			Q1 & Q2 - values are the IDs of the questions to present. 

			questionParam 	-	 the value of the name of the hidden form parameters for the question IDs

			answerParam 	-	 the name of the form parameters which take the answers
-->		

<xsl:param name="Q1" select="'default'"/>
<xsl:param name="Q2" select="'default'"/>
<xsl:param name="questionParam" select="'default'"/>
<xsl:param name="answerParam" select="'default'"/>

<!-- Root template
-->
<xsl:template match="/">

	<!--Start white content table w=593--> 
	<table width="593" border="0" cellspacing="0" cellpadding="4" bgcolor="#FFFFFF">
	<tr valign="top"> 
		<td>
			<br/><span id="headingBold">Forgot your password?<br/></span>
			Please answer both of the following questions in exactly the same way you 
			answered them last. Click &quot;submit&quot; when 
			done, and we'll email you a new password. <br/><br/>
			<br/>
			<!-- BEGIN  LOGIN BOX  -->
			<table width="582" border="0" cellspacing="0" cellpadding="0">
			<!-- Show question 1 -->
			<xsl:apply-templates select="QUESTION/QUESTION[@QUESTION_ID=$Q1]">
				<xsl:with-param name="qNum" select="1"/>
			</xsl:apply-templates>
			<!-- Show question 2 -->
			<xsl:apply-templates select="QUESTION/QUESTION[@QUESTION_ID=$Q2]">
				<xsl:with-param name="qNum" select="2"/>
			</xsl:apply-templates>
			<tr valign="top"> 
				<td width="158" align="right" bgcolor="#FFFFFF">&#160;</td>
				<td width="424" bgcolor="#FFFFFF"><br/></td>
			</tr>
			<tr valign="top"> 
				<td width="158" align="right" bgcolor="#FFFFFF">&#160;</td>
				<td width="424" bgcolor="#FFFFFF"><input type="image" src="images/buttons_sm_submit.gif" width="124" height="30" vspace="10"/></td>
			</tr>
			</table>
			<br/>
		</td>
	</tr>
	</table>	<!--End white content table w=593-->
</xsl:template>

<!-- Template for element QUESTION 
-->
<xsl:template match="QUESTION">
	<xsl:param name="qNum" select="'default'"/>
	<tr valign="top"> 
		<td width="158" align="right"><span id="heading">Question <xsl:value-of select="@QUESTION_ID"/>:&#160;</span></td>
		<td width="424"><span id="headingBold"><xsl:value-of select="QUESTION_DESC"/></span></td>
	</tr>
	<tr valign="top"> 
		<td width="158" align="right"><span id="heading">Enter Answer:&#160;</span></td>
		<td width="424">	
			<!-- Hidden input for question ID	-->
			<input type="hidden"><xsl:attribute name="value"><xsl:value-of select="@QUESTION_ID"/></xsl:attribute><xsl:attribute name="name"><xsl:value-of select="$questionParam"/></xsl:attribute></input>
			<span id="heading"><textarea cols="25" rows="3"><xsl:attribute name="name"><xsl:value-of select="$answerParam"/></xsl:attribute></textarea><br/></span>
			<span id="tinytext">(Please note that answers are case-specific	and must be remembered exactly as last entered.) </span> 
		</td>
	</tr>
	
</xsl:template>

</xsl:stylesheet>

